#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

int main() {
    int N_val;
    scanf("%d", &N_val);
    char *input_str = (char*)malloc((N_val + 1) * sizeof(char));
    scanf("%s", input_str);

    int plus_pos = -1;
    int *hash_positions = (int*)malloc(N_val * sizeof(int));
    int hash_count = 0;

    for (int idx = 0; idx < N_val; idx++) {
        if (input_str[idx] == '+') {
            plus_pos = idx;
        }
        if (input_str[idx] == '#') {
            hash_positions[hash_count++] = idx;
        }
    }

    int smallest_distance = N_val;

    for (int hash_idx = 0; hash_idx < hash_count; hash_idx++) {
        int current_pos = hash_positions[hash_idx];
        int linear_dist = abs(plus_pos - current_pos);
        int circular_dist = linear_dist;

        if (circular_dist > N_val - circular_dist) {
            circular_dist = N_val - circular_dist;
        }

        if (circular_dist < smallest_distance) {
            smallest_distance = circular_dist;
        }
    }

    printf("%d\n", smallest_distance);

    free(input_str);
    free(hash_positions);
    return 0;
}